/* -------------------------------------------------- */
if  exists (select * from sys.objects where object_id = OBJECT_ID(N'[dbo].[bwsp_PruefRZeitraum]') and type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
	drop function [dbo].[bwsp_PruefRZeitraum]
go

if  exists (select * from sys.objects where object_id = OBJECT_ID(N'[dbo].[bwsp_wawi_zeitraum9loeschen]') and type in (N'P', N'PC'))
	drop procedure [dbo].[bwsp_wawi_zeitraum9loeschen]
go

if  exists (select * from sys.objects where object_id = OBJECT_ID(N'[dbo].[bwsp_wawi_zeitraum9loeschen_bel]') and type in (N'P', N'PC'))
	drop procedure [dbo].[bwsp_wawi_zeitraum9loeschen_bel]
go

if  exists (select * from sys.objects where object_id = OBJECT_ID(N'[dbo].[bwsp_wawi_zeitraum9loeschen_pos]') and type in (N'P', N'PC'))
	drop procedure [dbo].[bwsp_wawi_zeitraum9loeschen_pos]
go

if  exists (select * from sys.objects where object_id = OBJECT_ID(N'[dbo].[bwsp_wawi_zeitraum9loeschen_sercha]') and type in (N'P', N'PC'))
	drop procedure [dbo].[bwsp_wawi_zeitraum9loeschen_sercha]
go

if  exists (select * from sys.objects where object_id = OBJECT_ID(N'[dbo].[bwsp_wawi_zeitraum9loeschen_dbp15]') and type in (N'P', N'PC'))
	drop procedure [dbo].[bwsp_wawi_zeitraum9loeschen_dbp15]
go

if  exists (select * from sys.objects where object_id = OBJECT_ID(N'[dbo].[bwsp_wawi_zeitraum9loeschen_dbp21]') and type in (N'P', N'PC'))
	drop procedure [dbo].[bwsp_wawi_zeitraum9loeschen_dbp21]
go

/* ----- Da derzeit keine Kasse in SQL, nicht notwendig ----- 
if  exists (select * from sys.objects where object_id = OBJECT_ID(N'[dbo].[bwsp_wawi_zeitraum9loeschen_dbp28]') and type in (N'P', N'PC'))
	drop procedure [dbo].[bwsp_wawi_zeitraum9loeschen_dbp28]
*/

if  exists (select * from sys.objects where object_id = OBJECT_ID(N'[dbo].[bwsp_wawi_zeitraum9loeschen_idb_se0025]') and type in (N'P', N'PC'))
	drop procedure [dbo].[bwsp_wawi_zeitraum9loeschen_idb_se0025]
go

if  exists (select * from sys.objects where object_id = OBJECT_ID(N'[dbo].[bwsp_wawi_zeitraum9loeschen_idb_se0147]') and type in (N'P', N'PC'))
	drop procedure [dbo].[bwsp_wawi_zeitraum9loeschen_idb_se0147]
go

if  exists (select * from sys.objects where object_id = OBJECT_ID(N'[dbo].[bwsp_wawi_zeitraum9loeschen_statistik]') and type in (N'P', N'PC'))
	drop procedure [dbo].[bwsp_wawi_zeitraum9loeschen_statistik]	
go
/* -------------------------------------------------- */

create function[dbo].[bwsp_PruefRZeitraum]
(
	@jj int
)
returns int
begin
	declare @rv int
	set @rv = 0
	if exists (select * from RZEITRAEUME where ID=@jj+2)
		set @rv = 1
	
	return @rv	
end
go

create procedure[dbo].[bwsp_wawi_zeitraum9loeschen]
as
begin
	if (dbo.bwsp_PruefRZeitraum(9) <> 1)
		return
	
	delete from
		RZEITRAEUME
	where
		ID=11
		
	exec [dbo].[bwsp_wawi_zeitraum9loeschen_bel]
	exec [dbo].[bwsp_wawi_zeitraum9loeschen_pos]
	exec [dbo].[bwsp_wawi_zeitraum9loeschen_sercha]
	exec [dbo].[bwsp_wawi_zeitraum9loeschen_dbp15]
	exec [dbo].[bwsp_wawi_zeitraum9loeschen_dbp21]
	--exec [dbo].[bwsp_wawi_zeitraum9loeschen_dbp28]
	exec [dbo].[bwsp_wawi_zeitraum9loeschen_idb_se0025]
	exec [dbo].[bwsp_wawi_zeitraum9loeschen_idb_se0147]
	exec [dbo].[bwsp_wawi_zeitraum9loeschen_statistik]		
end
go

create procedure[dbo].[bwsp_wawi_zeitraum9loeschen_bel]
as
begin
	if (dbo.bwsp_IsPhysicalTable ('RVTX21') = 0)
		return
		
	/* Beleg-Langtexte lschen */
	delete from
		RVTX21 
	from 
		RVTX21 t
		INNER JOIN
			RBELEG b
		on
			substring(t.IND,charindex(',', t.IND)+1,30) = cast (BEL_0_1 as varchar(1)) + BEL_1_1 + BEL_2_1 + cast(BEL_3_8 as varchar(8))
			and BEL_0_1 = 9
			
	if (dbo.bwsp_IsPhysicalTable ('RBELEG') = 0)
		return
		
	/* Beleg lschen */
	delete from
		RBELEG	
	where
		BEL_0_1 = 9
end
go

create procedure[dbo].[bwsp_wawi_zeitraum9loeschen_pos]
as
begin
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT') = 0)
		return
		
	/* Pos-Langtexte (Positionsnotiz) lschen*/
	delete from
		RVTX21
	from
		RVTX21 t
		inner join
			RPOSIT
		on
			(
				t.IND = '@POSTXT,' + ltrim(str(POS_645_10)) 
				or t.IND = '@POS2TXT,' + ltrim(str(POS_645_10)) 
				or t.IND = '@POS3TXT,' + ltrim(str(POS_645_10)) 
				or t.IND = '@POS4TXT,' + ltrim(str(POS_645_10))
			)
			and POS_0_1 = 9		
		
	/* Pos Zusatzindexe lschen (Aufteilung abhnging von SQLOPT,33 + SQLOPT,32)*/
	if (dbo.bwsp_IsPhysicalTable ('RPONDX') = 1)
		delete from 
			RPONDX
		from RPONDX z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID
					
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_1') = 1)
		delete from 
			RPONDX_1
		from RPONDX_1 z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_2') = 1)
		delete from 
			RPONDX_2
		from RPONDX_2 z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_3') = 1)
		delete from 
			RPONDX_3
		from RPONDX_3 z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID			

	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_4') = 1)
		delete from 
			RPONDX_4
		from RPONDX_4 z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID	
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_5') = 1)
		delete from 
			RPONDX_5
		from RPONDX_5 z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID	
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_6') = 1)
		delete from 
			RPONDX_6
		from RPONDX_6 z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID	
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_3') = 1)
		delete from 
			RPONDX_3
		from RPONDX_3 z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID	
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_7') = 1)
		delete from 
			RPONDX_7
		from RPONDX_7 z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID	
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_8') = 1)
		delete from 
			RPONDX_8
		from RPONDX_8 z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID	
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_9') = 1)
		delete from 
			RPONDX_9
		from RPONDX_9 z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID	
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_A') = 1)
		delete from 
			RPONDX_A
		from RPONDX_A z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID	
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_B') = 1)
		delete from 
			RPONDX_B
		from RPONDX_B z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID	
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_C') = 1)
		delete from 
			RPONDX_C
		from RPONDX_C z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID	
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_D') = 1)
		delete from 
			RPONDX_D
		from RPONDX_D z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID	
				
	if (dbo.bwsp_IsPhysicalTable ('RPOSIT_E') = 1)
		delete from 
			RPONDX_E
		from RPONDX_E z
			inner join
				RPOSIT
			on
				CONVERT(int,substring(z.IND,53,10)) = RPOSIT.ID	
						
	/* Pos lschen */
	delete from
		RPOSIT
	where POS_0_1=9
end
go

create procedure[dbo].[bwsp_wawi_zeitraum9loeschen_sercha]
as
begin
	if (dbo.bwsp_IsPhysicalTable ('SERZPOS') = 0)
		return
		
	/* Seriennr. Bewegungen lschen*/
	delete from 
		SERZPOS
	where
		SPO_1_1 = 9
	
	if (dbo.bwsp_IsPhysicalTable ('CHAZPOS') = 0)
		return
		
	/* Chargennr. Bewegungen lschen*/
	delete from 
		CHAZPOS
	where
		CPO_1_1 = 9
end
go

create procedure[dbo].[bwsp_wawi_zeitraum9loeschen_dbp15]
as
begin
	if (dbo.bwsp_IsPhysicalTable ('DBP15') = 0)
		return
	
	/* VT Abrechnungen lschen*/	
	delete from
		DBP15
	where
		DBP15_1640_1 is not null
		and DBP15_1640_1 = 9
end
go

create procedure[dbo].[bwsp_wawi_zeitraum9loeschen_dbp21]
as
begin
	if (dbo.bwsp_IsPhysicalTable ('DBP21') = 0)
		return
	
	/* VT Abrechnungen lschen*/	
	delete from
		DBP21
	where
		DBP21_1231_1 is not null
		and DBP21_1231_1 = 9
end
go

/* ----- Da derzeit keine Kasse in SQL, nicht notwendig ----- 
create procedure[dbo].[bwsp_wawi_zeitraum9loeschen_dbp28]
as
begin
	if (dbo.bwsp_IsPhysicalTable ('DBP28') = 0)
		return
	
	/* Kassenberichte lschen*/	
	delete from
		DBP28
	where
		DBP28_1255_1 is not null
		and DBP28_1255_1 = 9
end
*/

create procedure[dbo].[bwsp_wawi_zeitraum9loeschen_idb_se0025]
as
begin
	if (dbo.bwsp_IsPhysicalTable ('IDB_SE0025') = 0)
		return

	/* Belegzeitrume lschen */
	delete from
		IDB_SE0025S
	where
		cast(substring(IDB_0_4,1,1) as int) = 9
end
go

create procedure[dbo].[bwsp_wawi_zeitraum9loeschen_idb_se0147]
as
begin
	if (dbo.bwsp_IsPhysicalTable ('IDB_SE0147') = 0)
		return
		
	/* Belegzeitraum/Indiv. Perioden lschen*/
	delete from
		IDB_SE0147S
	where
		IDB_0_1 = 9
end
go

create procedure [dbo].[bwsp_wawi_zeitraum9loeschen_statistik]
as
begin
	/*Statistiken bereinigen*/
	delete from
		RSTG_ADRWGR
	where
		STG_1_1 = 9
		
	delete from
		RSTG_VTRWGR
	where
		STG_1_1 = 9
		
	delete from
		RSTG_USASTSVERB
	where
		STG_1_1 = 9
		
	delete from
		RSTG_ADRART
	where
		STG_1_1 = 9
		
	delete from
		RSTG_LIEFADRART
	where
		STG_1_1 = 9
		
	delete from
		RSTG_ART
	where
		STG_1_1 = 9
		
	delete from
		RSTG_ARTLAGERBUCH
	where
		STG_1_1 = 9
		
	delete from
		RSTG_ADR
	where
		STG_1_1 = 9
		
	delete from
		RSTG_LIEFERADR
	where
		STG_1_1 = 9
		
	delete from
		RSTG_ADROP
	where
		STG_1_1 = 9
		
	delete from
		RSTG_PROJEKT
	where
		STG_1_1 = 9
end
go










	